% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{add_verticality}
\alias{add_verticality}
\title{Add point-wise verticality from local PCA}
\usage{
add_verticality(las, k = 30, name = "verticality")
}
\arguments{
\item{las}{A \code{LAS} object.}

\item{k}{Number of nearest neighbors for local PCA.}

\item{name}{Name of the attribute to store.}
}
\value{
The input `LAS` object with a new numeric attribute
containing verticality values (0–1).
}
\description{
Computes a verticality metric (0-1) for each point in a LAS object based on
the z-component of the dominant local PCA eigenvector.
}
\examples{
\donttest{
las = lidR::readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = add_verticality(las, k = 20)
head(las@data)
}
}
