% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action_functions.R
\name{copy_files_to_left}
\alias{copy_files_to_left}
\title{Copy files from right directory to left directory}
\usage{
copy_files_to_left(left_dir, right_dir, files_to_copy, recurse = TRUE)
}
\arguments{
\item{left_dir}{Path of the left (destination) directory.}

\item{right_dir}{Path of the right (source) directory.}

\item{files_to_copy}{Data frame containing paths of files to copy and their synchronization status.}

\item{recurse}{Logical, default is TRUE.
\itemize{
\item If TRUE: Files are copied into corresponding subdirectories in the left directory. If a subdirectory doesn't exist in the left directory, it will be created.
\item If FALSE: Files are copied to the top level of the left directory.
}}
}
\value{
Invisible TRUE upon successful completion of the file copying process.
}
\description{
This function copies files from a right (source) directory to a left (destination) directory based on a provided data frame containing file paths and synchronization status.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the source (right) and destination (left) directories exist and creates the destination directory if it doesn't already exist.
\item Copies files from the right directory to the corresponding subdirectory in the left directory based on the provided file paths.
}
}
\keyword{internal}
