% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_calc_pairwise.R
\name{nn_metrics}
\alias{nn_metrics}
\title{Nearest Neighbour Metrics}
\usage{
nn_metrics(
  data,
  add_coords = FALSE,
  geo = FALSE,
  verbose = FALSE,
  parallelize = FALSE
)
}
\arguments{
\item{data}{A dataframe with the group's positional timeseries for one set.
Column names must include: \code{id}, \code{t}, \code{head}, \code{x}, \code{y}.
The calculations are based on the \code{swaRm} package.}

\item{add_coords}{Logical, whether the data on relative positions of
nearest neighbours should be converted into
coordinates in the reference frame of the focal individual (\code{nnx}, \code{nny}). This
can be useful for visualization purposes but it is not used in the package
pipeling. Default = 'FALSE'.}

\item{geo}{Logical, whether positions are geographic coordinates, default = FALSE.}

\item{verbose}{Logical, whether to post updates on progress.}

\item{parallelize}{Logical, whether to parallelize the function over time.}
}
\value{
The input dataframe with new columns for nearest neighbor id (\code{nn_id}),
bearing angle (\code{bangl}), and distance (\code{nnd}).
If \code{add_coords} is TRUE, the columns \code{nnx} and \code{nny} are  added.
}
\description{
This function calculates the bearing angle and distance from
all focal individuals in a group to their nearest neighbor over time.
}
\examples{

data <- data.frame(
 set = rep("1", 50),
 t = as.POSIXct(rep(1:25, 2), origin = Sys.time()),
 id = c(rep(1, 25), rep(2, 25)),
 x = rnorm(50),
 y = rnorm(50),
 head = runif(50, 0, 2 * pi)
 )

nnm <- nn_metrics(data, geo = FALSE)

}
\seealso{
\code{\link{add_rel_pos_coords}, \link{group_metrics}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
