\name{calcse}
\alias{calcse}
\title{Computation of standard error estimate of a contrast measure from a multi-arm trial}
\usage{
calcse(se1,se2,n1,n2,n0)
}
\arguments{
\item{se1}{The standard error estimate of a contrast measure (e.g., log hazard ratio) estimator for arms 1 vs. 0.}
\item{se2}{The standard error estimate of a contrast measure (e.g., log hazard ratio) estimator for arms 2 vs. 0.}
\item{n1}{The sample size of arm 1.}
\item{n2}{The sample size of arm 2.}
\item{n0}{The sample size of arm 0.}
}
\value{
The standard error estimate of a contrast measure (e.g., log hazard ratio) estimator for arms 1 vs. 2.
}
\description{
In network meta-analysis, standard error estimates cannot often be obtained for some contrasts of arms in multi-arm trials. 
This function calculate the standard error estimate of a contrast measure (e.g., log hazard ratio) estimator from partially obtained summary data in multi-arm trials. 
Without loss of generality, we consider three arms 0, 1 and 2 in the corresponding trial, and suppose the standard error of the contrast measure comparing the arms 1 vs. 2 is not obtained; however, those comparing the arms 1 vs. 0 and 2 vs. 0 are obtained. 
We can calculate the standard error estimate comparing the arms 1 vs. 2 from the partially available data.
}
\references{
Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv: 10.1101/2025.01.23.25321051.

Woods, B. S., Hawkins, N., Scott, D. A. (2010). Network meta-analysis on the log-hazard scale, combining count and hazard ratio statistics accounting for multi-arm trials: a tutorial. \emph{BMC Medical Research Methodology} \strong{10}, 54.
}

\examples{
calcse(0.096,0.092,1521,1534,1524)
}

