% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surreal-text.R
\name{surreal_text}
\alias{surreal_text}
\title{Apply the surreal method to a text string}
\usage{
surreal_text(
  text = "hello world",
  cex = 4,
  R_squared = 0.3,
  p = 5,
  n_add_points = 40,
  max_iter = 100,
  tolerance = 0.01,
  verbose = FALSE
)
}
\arguments{
\item{text}{Character. A plain text message to be plotted. Default is "hello world".}

\item{cex}{Numeric. A value specifying the relative size of the text. Default is 4.}

\item{R_squared}{Numeric. Desired R-squared value. Default is 0.3.}

\item{p}{Integer. Desired number of columns for matrix X. Default is 5.}

\item{n_add_points}{Integer. Number of points to add in border transformation. Default is 40.}

\item{max_iter}{Integer. Maximum number of iterations for convergence. Default is 100.}

\item{tolerance}{Numeric. Criteria for detecting convergence and stopping optimization early. Default is 0.01.}

\item{verbose}{Logical. If TRUE, prints progress information. Default is FALSE.}
}
\value{
A data.frame containing the results of the surreal method application.
}
\description{
This function applies the surreal method to a text string. It first creates a
temporary plot with the text, processes the image, and then applies the surreal
method to the data.
}
\examples{
# Create a surreal plot of the text "R is fun" appearing on one line
r_is_fun_result <- surreal_text("R is fun", verbose = TRUE)

# Create a surreal plot of the text "Statistics Rocks" by using an escape
# character to create a second line between "Statistics" and "Rocks"
stat_rocks_result <- surreal_text("Statistics\nRocks", verbose = TRUE)

}
\seealso{
\code{\link[=surreal]{surreal()}} for details on the surreal method parameters.
}
