% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{createForestSamples}
\alias{createForestSamples}
\title{Create ForestSamples Object}
\usage{
createForestSamples(
  num_trees,
  leaf_dimension = 1,
  is_leaf_constant = FALSE,
  is_exponentiated = FALSE
)
}
\arguments{
\item{num_trees}{Number of trees}

\item{leaf_dimension}{Dimensionality of the outcome model}

\item{is_leaf_constant}{Whether leaf is constant}

\item{is_exponentiated}{Whether forest predictions should be exponentiated before being returned}
}
\value{
\code{ForestSamples} object
}
\description{
Create a container of forest samples

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
num_trees <- 100
leaf_dimension <- 2
is_leaf_constant <- FALSE
is_exponentiated <- FALSE
forest_samples <- createForestSamples(num_trees, leaf_dimension, is_leaf_constant, is_exponentiated)
}
