% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stlg.R
\name{STLg}
\alias{STLg}
\title{Pair correlation function for spatio-temporal point processes on linear networks}
\usage{
STLg(X,r=NULL,t=NULL,nxy=10)
}
\arguments{
\item{X}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{r}{values of argument r where pair correlation function will be evaluated. optional}

\item{t}{values of argument t where pair correlation function will be evaluated. optional}

\item{nxy}{pixel array dimensions. optional}
}
\value{
An object of class \code{sumstlpp}.
}
\description{
This function computes the pair correlation function for spatio-temporal point patterns on linear networks.
}
\details{
This function calculates the pair correlation function for a homogeneous spatio-temporal point patterns on a linear network.
}
\examples{
X <- rpoistlpp(.2,a=0,b=5,L=easynet)
g <- STLg(X)
plot(g)

}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link[spatstat.explore]{pcf}}, \code{\link{STLK}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
