% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear.R
\name{clear}
\alias{clear}
\title{Clear Plot, Global Environment, and Console}
\usage{
clear()
}
\value{
Invisibly returns NULL. Prints a colored confirmation message.
}
\description{
Clears plot, global environment, and console. On first use the user is
prompted to authorize clearing the environment to comply with CRAN rules.
}
\details{
This function performs three cleanup operations:
\itemize{
  \item \strong{Plot}: Closes all open graphics devices (except the null device)
  \item \strong{Global environment}: Removes all objects from the global environment
  \item \strong{Console}: Clears the console screen (only in interactive sessions)
}

\code{clear()} will not modify the global environment unless you have
previously typed "yes" when prompted. If you do not type "yes", you are asked
again next time; only "yes" is remembered for future sessions.

\strong{Warning}: This function deletes all objects in the global environment.
Save anything that you wish to keep before running.
}
\examples{
\donttest{
# Interactive use: clear workspace, console, and plots
# First run may prompt; once you type "yes", your preference is saved.
clear()
}

}
