% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compCurves.R
\name{compCurves}
\alias{compCurves}
\title{Compare regression curves in a pairwise fashion}
\usage{
compCurves(
  obj,
  adjusted = c("none", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr")
)
}
\arguments{
\item{obj}{a drc object}

\item{adjusted}{a character string, for selecting the method of multiplicity
correction. Must be one of: c("none", "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr")}
}
\value{
returns a list with two slots: (i) Pairs: the list of peirwise comparisons,
with F values and P-values; (ii) Letters: letter display for the different
curves
}
\description{
For regression models containing grouping factors and fitted with the 'drm'
function in the 'drc' package, this function compares the
different curves for each factor level in a pairwise fashion,
according to a series of F tests for the extra-sum-of-squares. Works only with
'drc' objects
}
\examples{
metamitron <- getAgroData("metamitron")
head(metamitron)
tail(metamitron)

mod1 <- drm(Conc ~ Time, fct = DRC.expoDecay(),
               curveid = Herbicide,
               data = metamitron)
summary(mod1)
compCurves(mod1, adjusted = "bonferroni")


}
\author{
Andrea Onofri
}
