% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtrees.R
\name{depsubtree}
\alias{depsubtree}
\title{Extract dependency subtree}
\usage{
depsubtree(object, var, other_stages = c("NA", "indep", "full"))
}
\arguments{
\item{object}{an object of class \code{\link{sevt}}.}

\item{var}{the name of one of the variable of the staged event tree.}

\item{other_stages}{how to set stages for other variables (if any).}
}
\value{
an object of class \code{\link{sevt}} representing the
dependency sub-tree.
}
\description{
Extract the dependency subtree of a staged tree with respect to
a variable
}
\details{
The dependency sub-tree is a staged event tree which is
sufficient to describe the conditional distribution of the variable
\code{var} given its predecessors in the original tree represented by
\code{object}.
In particular the preceding variables are restricted to the
parents of \code{var} in the minimal-DAG obtained with
\code{\link{as_parentslist}}. This is the minimal set of
variables which contexts are sufficient to fully represent the
conditional distribution of \code{var}.
Stages for variables different from \code{var} are either set to
NA, or to the full or indep model, depending on \code{other_stages}.
}
\examples{
mod <- stages_kmeans(full(Titanic), k = 2)
par(mfrow = c(1, 2))
plot(mod, main = "staged tree")
plot(depsubtree(mod, "Age"), main = "dependency subtree for Age")
par(mfrow = c(1, 1))
}
