% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_parallel_execution.R
\name{setup_parallel_execution}
\alias{setup_parallel_execution}
\title{Setup parallel execution with automatic backend detection}
\usage{
setup_parallel_execution(cluster = NULL, n.cores = parallel::detectCores() - 1)
}
\arguments{
\item{cluster}{A cluster object from parallel::makeCluster(), or NULL}

\item{n.cores}{Number of cores for internal cluster creation}
}
\value{
A list with:
\itemize{
\item cluster: The cluster object to pass to child functions (or NULL)
\item mode: One of "user_backend", "external_cluster", "internal_cluster", "sequential"
\item cleanup: A function to call in on.exit() for proper cleanup
}
}
\description{
Internal helper to manage parallel backend setup with support
for user-managed backends, external clusters, and internal clusters.
}
\seealso{
Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
