% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.annulus.R
\name{sample.annulus}
\alias{sample.annulus}
\title{Sample annulus}
\usage{
sample.annulus(x, r1, r2, size = 10, ...)
}
\arguments{
\item{x}{An sf POINT class object}

\item{r1}{Numeric value defining inner radius of annulus 
(in projection units)}

\item{r2}{Numeric value defining outer radius of annulus 
(in projection units)}

\item{size}{Number of samples}

\item{...}{Additional arguments passed to sf::st_sample}
}
\value{
sf POINTS object
}
\description{
Creates sample points based on annulus with defined 
inner and outer radius
}
\details{
Function can be used for distance based sampling which is a sampling method 
that can be used to capture spatially lagged variation.
}
\examples{
 library(sf)
 if(require(sp, quietly = TRUE)) {
   data(meuse, package = "sp")
   meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                     agr = "constant")

 xy <- meuse[2,]
 rs100 <- sample.annulus(xy, r1=50, r2=100, size = 50)
 rs200 <- sample.annulus(xy, r1=100, r2=200, size = 50)
 
 plot(st_geometry(rs200), pch=20, col="red")
   plot(st_geometry(rs100), pch=20, col="blue", add=TRUE)
   plot(st_geometry(xy), pch=20, cex=2, col="black", add=TRUE)
 legend("topright", legend=c("50-100m", "100-200m", "source"), 
        pch=c(20,20,20), col=c("blue","red","black"))

\donttest{
# Run on multiple points
rs100 <- sample.annulus(meuse[1:3,], r1=50, r2=100, 
                        size = 50)
rs200 <- sample.annulus(meuse[1:3,], r1=50, r2=200, 
                        size = 50)
plot(st_geometry(rs200), pch=20, col="red")
  plot(st_geometry(rs100), pch=20, col="blue", add=TRUE)
    plot(st_geometry(meuse[1:3,]), pch=20, cex=2, col="black", add=TRUE)
 legend("topright", legend=c("50-100m", "100-200m", "source"), 
        pch=c(20,20,20), col=c("blue","red","black"))
}
} else { 
  cat("Please install sp package to run example", "\n")
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
