% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophic.R
\name{plot.trophic_tbl}
\alias{plot.trophic_tbl}
\title{Plot a trophic table}
\usage{
\method{plot}{trophic_tbl}(x, shift = TRUE, ...)
}
\arguments{
\item{x}{A \code{trophic_tbl} object.}

\item{shift}{To shift x_axis between trophic level and avoid
the potential overlapping of arrows.}

\item{...}{Additional arguments (not used, for S3 consistency).}
}
\value{
A ggplot object.
}
\description{
Creates a simple graphical representation of a trophic network using ggplot2.
}
\details{
Nodes are positioned according to their trophic level:
\itemize{
  \item The y-axis represents trophic levels
  \item Nodes of the same level are placed on the same horizontal line
  \item The x-axis positions are assigned sequentially (0, 1, 2, ...)
}
Directed links are drawn from lower to higher trophic levels using arrows.
}
\examples{
net <- trophic() |>
  add_link("a", "b") |>
  add_link("b", "c")

plot(net)

}
