% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{playme}
\alias{playme}
\title{Play audio}
\usage{
playme(x, samplingRate = 16000, player = NULL, from = NULL, to = NULL)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{player}{the name of player to use, eg "aplay", "play", "vlc", etc.
Defaults to "play" on Linux, "afplay" on MacOS, and tuneR default on
Windows. In case of errors, try setting another default player for
\code{\link[tuneR]{play}}}

\item{from, to}{play a selected time range (s)}
}
\description{
Plays one or more sounds: wav/mp3 file(s), Wave objects, or numeric vectors.
This is a simple wrapper for the functionality provided by
\code{\link[tuneR]{play}}. Recommended players on Linux: "play" from the
"vox" library (default), "aplay".
}
\examples{
\dontrun{
# Play an audio file:
playme('pathToMyAudio/audio.wav')

# Create and play a numeric vector:
f0_Hz = 440
sound = sin(2 * pi * f0_Hz * (1:16000) / 16000)
playme(sound, 16000)
playme(sound, 16000, from = .1, to = .5)  # play from 100 to 500 ms

# In case of errors, look into tuneR::play(). For ex., you might need to
# specify which player to use:
playme(sound, 16000, player = 'aplay')

# To avoid doing it all the time, set the default player:
tuneR::setWavPlayer('aplay')
playme(sound, 16000)  # should now work without specifying the player
}
}
