% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM.R
\name{.ssm}
\alias{.ssm}
\title{SSM per sound}
\usage{
.ssm(
  audio,
  windowLength = 25,
  step = 5,
  overlap = NULL,
  win = 1,
  sparse = FALSE,
  maxFreq = NULL,
  nBands = NULL,
  MFCC = 2:13,
  input = c("mfcc", "melspec", "spectrum")[2],
  norm = FALSE,
  simil = c("cosine", "cor")[1],
  kernelLen = 100,
  kernelSD = 0.5,
  padWith = 0,
  plot = TRUE,
  main = NULL,
  heights = c(2, 1),
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  specPars = list(levels = seq(0, 1, length = 30), colorTheme = c("bw", "seewave",
    "heat.colors", "...")[2], xlab = "Time, s", ylab = "kHz"),
  ssmPars = list(levels = seq(0, 1, length = 30), colorTheme = c("bw", "seewave",
    "heat.colors", "...")[2], xlab = "Time, s", ylab = "Time, s"),
  noveltyPars = list(type = "b", pch = 16, col = "black", lwd = 3)
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{windowLength}{length of FFT window, ms (multiple values in a vector
produce a multi-resolution spectrogram)}

\item{step}{you can override \code{overlap} by specifying FFT step, ms - a
vector of the same length as windowLength (NB: because digital audio is
sampled at discrete time intervals of 1/samplingRate, the actual step and
thus the time stamps of STFT frames may be slightly different, eg 24.98866
instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{sparse}{if TRUE, the entire SSM is not calculated, but only the central
region needed to extract the novelty contour (speeds up the processing)}

\item{maxFreq}{highest band edge of mel filters, Hz. Defaults to
\code{samplingRate / 2}. See \code{\link[tuneR]{melfcc}}}

\item{nBands}{number of warped spectral bands to use. Defaults to \code{100 *
windowLength / 20}. See \code{\link[tuneR]{melfcc}}}

\item{MFCC}{which mel-frequency cepstral coefficients to use; defaults to
\code{2:13}}

\item{input}{the spectral representation used to calculate the SSM}

\item{norm}{if TRUE, the spectrum of each STFT frame is normalized}

\item{simil}{method for comparing frames: "cosine" = cosine similarity, "cor"
= Pearson's correlation}

\item{kernelLen}{length of checkerboard kernel for calculating novelty, ms
(larger values favor global, slow vs. local, fast novelty)}

\item{kernelSD}{SD of checkerboard kernel for calculating novelty}

\item{padWith}{how to treat edges when calculating novelty: NA = treat sound
before and after the recording as unknown, 0 = treat it as silence}

\item{plot}{if TRUE, plots the SSM}

\item{main}{plot title}

\item{heights}{relative sizes of the SSM and spectrogram/novelty plot}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{specPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the \code{\link{spectrogram}}}

\item{ssmPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the plot of SSM}

\item{noveltyPars}{graphical parameters passed to
\code{\link[graphics]{lines}} and affecting the novelty contour}
}
\description{
Internal soundgen function.
}
\keyword{internal}
