% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency_scales.R
\name{HzToSemitones}
\alias{HzToSemitones}
\alias{semitonesToHz}
\title{Convert semitones to Hz and back}
\usage{
HzToSemitones(x, ref = 0.5109875)

semitonesToHz(x, ref = 0.5109875)
}
\arguments{
\item{x}{A vector or matrix of frequencies}

\item{ref}{frequency of the reference value (defaults to C-5, 0.51 Hz)}
}
\description{
Converts between Hz and semitones above C-5 (~0.5109875 Hz) or another
reference frequency. This may not seem very useful, but note that this gives
us a nice logarithmic scale for generating natural pitch transitions. Accepts
vectors and missing values.
}
\examples{
s = HzToSemitones(c(440, 293, 115))
# to convert to musical notation
notesDict$note[1 + round(s)]
# note the "1 +": semitones ABOVE C-5, i.e. notesDict[1, ] is C-5

# Any reference tone can be specified. For ex., for semitones above C0, use:
HzToSemitones(440, ref = 16.35)
# TIP: see notesDict for a table of Hz frequencies to musical notation

semitonesToHz(c(117, 105, 60))
}
\seealso{
\code{\link{HzToOther}}
}
