% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency_scales.R
\name{HzToERB}
\alias{HzToERB}
\alias{ERBToHz}
\title{Convert Hz to ERB rate}
\usage{
HzToERB(x, method = c("linear", "quadratic")[1])

ERBToHz(x, method = c("linear", "quadratic")[1])
}
\arguments{
\item{x}{vector or matrix of frequencies}

\item{method}{approximation to use: "linear" = Glasberg & Moore (1990),
"quadratic" = Moore & Glasberg (1983)}
}
\description{
Converts from Hz to the number of Equivalent Rectangular Bandwidths (ERBs)
below input frequency. See https://www2.ling.su.se/staff/hartmut/bark.htm and
https://en.wikipedia.org/wiki/Equivalent_rectangular_bandwidth
}
\section{Functions}{
\itemize{
\item \code{ERBToHz()}: Convert ERB rate to Hz

}}
\examples{
HzToERB(c(-20, 20, 100, 440, 1000, NA))

f = 20:20000
erb_lin = HzToERB(f, 'linear')
erb_quadratic = HzToERB(f, 'quadratic')
plot(f, erb_lin, log = 'x', type = 'l')
points(f, erb_quadratic, col = 'blue', type = 'l')

freqs_Hz = c(-20, 20, 100, 440, 1000, 20000, NA)
e_lin = HzToERB(freqs_Hz, 'linear')
ERBToHz(e_lin, 'linear')

e_quad = HzToERB(freqs_Hz, 'quadratic')
ERBToHz(e_quad, 'quadratic')

# compare with the bark scale:
barks = HzToOther(f, 'bark')
points(f, barks / max(barks) * max(erb_lin),
  col = 'red', type = 'l', lty = 2)
}
\references{
\itemize{
  \item Moore, B. C., & Glasberg, B. R. (1983). Suggested formulae for
  calculating auditory-filter bandwidths and excitation patterns. The journal
  of the acoustical society of America, 74(3), 750-753.
  \item Glasberg, B. R., & Moore, B. C. (1990). Derivation of auditory filter
  shapes from notched-noise data. Hearing research, 47(1-2), 103-138.
}
}
\seealso{
\code{\link{HzToOther}}
}
