% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\alias{estimate.slca}
\title{Estimate Parameters of an \code{slca} Object}
\usage{
estimate(x, ...)

\method{estimate}{slca}(x,
   data,
   method = c("em", "hybrid", "nlm"),
   fix2zero = NULL,
   control = slcaControl(), ...)
}
\arguments{
\item{x}{an \code{slca} object defining the \code{slca} model to be estimated.}

\item{...}{additional arguments passed to the estimation process.}

\item{data}{a \code{data.frame} containing the observed categorical variables included in the model.}

\item{method}{a character string specifying the estimation method for SLCM parameters. The default is \code{"em"}, which uses the expectation-maximization (EM) algorithm. The alternative \code{"nlm"} employs the Newton-Raphson algorithm via the \code{nlm} function, while \code{"hybrid"} combines both approaches, starting with EM and finishing with \code{nlm} for refined estimates.}

\item{fix2zero}{a \code{vector} specifying parameters to be constrained to zero. See the 'Details' section for further information.}

\item{control}{a \code{list} of control parameters for the estimation procedure. Modify default values using \code{\link[=slcaControl]{slcaControl()}}.}
}
\value{
An object of class \code{slcafit} containing the following components:
\item{model}{a \code{list} describing of the model structure.}
\item{method}{the estimation method used.}
\item{arg}{a brief description of the model used during estimation.}
\item{mf}{the \code{data.frame} used for estimation.}
\item{par}{the log of the estimated paramters.}
\item{logit}{the log-odds of the estimated parameters.}
\item{score}{the score function for the estimated parameters.}
\item{posterior}{a \code{list} of posterior probablities for each latent class variable.}
\item{convergence}{a logical indicator of whether convergence was achieved.}
\item{loglikelihood}{the loglikelihood value of the estimated model.}
\item{control}{the control settings used during the estimation process.}

The returned object can be further processed using the \link[slca]{param} function to extract the estimated parameters or their standard errors. The \link[slca]{regress} function allows for logistic regression analysis using a three-step approach to evaluate the effects of external variables on latent class variables. Additionally, several other methods are available, including \link[slca]{predict.slcafit}, \link[slca]{reorder.slcafit}, \link[slca]{gof}, and others.
}
\description{
Estimates the parameters of a model created using the \code{slca} function.
}
\details{
The \code{fix2zero} argument allows you to constrain specific parameters to zero. Each parameter is associated with a unique index, which can be identified using the \link[slca]{param} function with the argument \code{index = TRUE}. To apply constraints, provide the relevant parameter indices in the \code{fix2zero} arguments with vector.
}
\examples{
m <- slca(lc[3] ~ y1 + y2 + y3 + y4)
pi <- rep(1 / 3, 3)
rho <- c(.9, .1, .9, .1, .9, .1, .9, .1, # class 1
         .9, .1, .9, .1, .1, .9, .1, .9, # class 2
         .1, .9, .1, .9, .1, .9, .1, .9) # class 3
dt <- simulate(m, 200, parm = c(pi, rho))
estimate(m, dt$response)

# Several estimation methods
estimate(m, dt$response, method = "em",
         control = slcaControl(verbose = TRUE)) # default
estimate(m, dt$response, method = "nlm",
         control = slcaControl(verbose = TRUE))
estimate(m, dt$response, method = "hybrid",
         control = slcaControl(verbose = TRUE))

# Parameter restriction
mf <- estimate(m, dt$response)
param(mf, index = TRUE)
mf0 <- estimate(mf, fix2zero = c(4, 6, 8, 10))
param(mf0)

# Estimation control
estimate(m, dt$response, control = slcaControl(nrep = 3, verbose = TRUE))
estimate(m, dt$response, control = slcaControl(init.param = c(pi, rho)))
}
\seealso{
\code{\link[=slca]{slca()}} \code{\link[=param]{param()}} \code{\link[=slcaControl]{slcaControl()}}
}
