% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wvar_cpp}
\alias{wvar_cpp}
\title{Computes the (MODWT) wavelet variance}
\usage{
wvar_cpp(signal_modwt_bw, robust, eff, alpha, ci_type)
}
\arguments{
\item{signal_modwt_bw}{A \code{field<vec>} that contains the modwt decomposition after it has been brick walled.}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{ci_type}{A \code{String} indicating the confidence interval being calculated. Valid value: "eta3"}
}
\value{
A \code{mat} with the structure:
  \item{"variance"}{Wavelet Variance}
  \item{"low"}{Lower CI}
  \item{"high"}{Upper CI}
}
\description{
Calculates the (MODWT) wavelet variance
}
\details{
This function does the heavy lifting with the signal_modwt_bw
}
\keyword{internal}
