% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{grouped}
\alias{grouped}
\title{Mark parameters as grouped}
\usage{
grouped(...)
}
\arguments{
\item{...}{One or more vectors of equal length to be grouped together.
Each argument will be named according to the symbol provided.}
}
\value{
An object of class \code{grouped_params}, essentially a named list
where all elements have the same length.
}
\description{
Utility function to combine several vectors of equal length into
a grouped parameter object. This allows parameters that should vary together
across scenarios to be treated as a unit in \code{\link{scenario_list}}.
}
\examples{
# Define two grouped parameters of equal length
g <- grouped(x = 1:3, y = c(10, 20, 30))
g
}
\seealso{
\code{\link{scenario_list}} for generating scenario combinations
that make use of grouped parameters.
}
\concept{utility}
