% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEventTV.R
\name{simEventTV}
\alias{simEventTV}
\title{simEventTV}
\usage{
simEventTV(
  N,
  beta = NULL,
  tv_eff = NULL,
  t_prime = Inf,
  eta = NULL,
  nu = NULL,
  at_risk = NULL,
  term_deltas = c(0, 1),
  max_cens = Inf,
  add_cov = NULL,
  override_beta = NULL,
  max_events = 10,
  lower = 10^(-15),
  upper = 200,
  gen_A0 = NULL,
  at_risk_cov = NULL
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{beta}{Matrix. Coefficients for covariates and processes. Columns correspond to events (\code{N0}, \code{N1}, ...),
rows correspond to covariates (\code{L0}, \code{A0}, ..., and past event counts).}

\item{tv_eff}{Matrix. Time-varying changes to \code{beta}, applied at time \code{t_prime}. Must have same dimensions as \code{beta}.}

\item{t_prime}{Numeric. Time at which \code{tv_eff} is added to \code{beta}.}

\item{eta}{Numeric vector. Shape parameters of Weibull intensities for each event.}

\item{nu}{Numeric vector. Scale parameters of Weibull intensities for each event.}

\item{at_risk}{Function. Determines which events an individual is at risk for, based on event history.}

\item{term_deltas}{Integer vector. Event types considered terminal (e.g., death).}

\item{max_cens}{Numeric. Maximum censoring time. Defaults to \code{Inf}.}

\item{add_cov}{Named list of functions for generating additional baseline covariates.
Each function takes one argument \code{N} and returns a vector of length \code{N}.}

\item{override_beta}{Named list to override elements of \code{beta}. Format:
\code{list("covariate" = c("event" = value))}.}

\item{max_events}{Integer. Maximum number of events allowed per individual.}

\item{lower}{Numeric. Lower bound for the root-finding algorithm used in inverse cumulative hazard computation.}

\item{upper}{Numeric. Upper bound for the root-finding algorithm used in inverse cumulative hazard computation.}

\item{gen_A0}{Function. Generates baseline treatment assignment. Takes arguments \code{N} and \code{L0}.}

\item{at_risk_cov}{Function. Function determining if an individual is at risk for each event type, given their covariates. Takes a numeric vector covariates and returns a binary vector. Default returns 1 for all events.}
}
\value{
A \code{data.table} with columns:
\item{ID:}{Individual identifier}
\item{Time:}{Time of event}
\item{Delta:}{Type of event}
\item{L0:}{Baseline covariate}
\item{A0:}{Baseline treatment}
\item{N0, N1, ...:}{Cumulative event counts}
\item{L1, L2, ...:}{Additional covariates (if specified)}
}
\description{
Simulate Event Data with Time-Varying Effects
}
\details{
\code{simEventTV} is a function that simulates event data, with the option of
adding time varying effects. The function is build up in the same way as \code{simEventData},
with the additional arguments \code{tv_eff} and \code{t_prime}, which specify the change
of the beta matrix at time \code{t_prime}.
}
\examples{
eta <- rep(0.1, 2)
simEventTV(N = 100, t_prime = 1, eta = eta, term_deltas = c(0, 1))

}
