% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_difference.R
\name{plot_difference}
\alias{plot_difference}
\title{Plot the difference between \eqn{\theta}s}
\usage{
plot_difference(difference, type = c("diff", "absolute_diff"), levels = 4)
}
\arguments{
\item{difference}{data.frame, data frame obtained with the function [diff_theta()]}

\item{type}{character, type of difference, either as is ("diff") or absolute ("absolute_diff"). Default is "diff".}

\item{levels}{integer, number of levels of the starting \eqn{\theta} Default is 4}
}
\value{
A ggplot object
}
\description{
Plot the difference or the absolute difference between the starting \eqn{\theta} and the \eqn{\theta} estimated with the STF as a function of different levels of the latent trait
}
\examples{
# set a seed to replicate the results
set.seed(999)
# Simulate person and item parameters
true_theta <- rnorm(1000)
b <- runif(30, -3, 3)
a <- runif(30, 0.6, 2)
parameters <- data.frame(b, a)
# simulate data
data <- sirt::sim.raschtype(true_theta, b = b, fixed.a = a)
stf <- uip(data, starting_theta = true_theta, item_par = parameters, num_item = 5)
# compute the difference between starting theta and that estimated with the stf
my_diff <- diff_theta(stf)
# plot the difference with default number of levels
plot_difference(my_diff, type = "diff")
# plot the absolute difference with 10 levels
plot_difference(my_diff, type = "absolute_diff", levels = 10)
}
