% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-sqlite.R
\name{DataStorageSQLite}
\alias{DataStorageSQLite}
\title{Data storage class with SQLite provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to SQLite backend using a unified
API for read/write operations
}
\examples{
db_path <- tempfile(fileext = ".sqlite")
data_storage <- DataStorageSQLite$new(db_path = db_path)

data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id1"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)

file.remove(db_path)
}
\section{Super classes}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{\link[shiny.telemetry:DataStorageSQLFamily]{shiny.telemetry::DataStorageSQLFamily}} -> \code{DataStorageSQLite}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStorageSQLite-new}{\code{DataStorageSQLite$new()}}
\item \href{#method-DataStorageSQLite-clone}{\code{DataStorageSQLite$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageSQLite-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageSQLite-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageSQLite$new(db_path = "user_stats.sqlite")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db_path}}{string with path to \code{SQLite} file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageSQLite-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageSQLite-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageSQLite$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
