% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R, R/model_ar.R, R/model_arima.R,
%   R/model_glm.R, R/model_lm.R, R/model_mgcv_gam.R, R/model_ranger.R,
%   R/model_workflow.R, R/model_xgboost.R
\name{get_model_specs}
\alias{get_model_specs}
\alias{get_model_specs.default}
\alias{get_model_specs.ar}
\alias{get_model_specs.Arima}
\alias{get_model_specs.forecast_ARIMA}
\alias{get_model_specs.glm}
\alias{get_model_specs.lm}
\alias{get_model_specs.gam}
\alias{get_model_specs.ranger}
\alias{get_model_specs.workflow}
\alias{get_model_specs.xgb.Booster}
\title{Fetches feature information from natively supported models}
\usage{
get_model_specs(x)

\method{get_model_specs}{default}(x)

\method{get_model_specs}{ar}(x)

\method{get_model_specs}{Arima}(x)

\method{get_model_specs}{forecast_ARIMA}(x)

\method{get_model_specs}{glm}(x)

\method{get_model_specs}{lm}(x)

\method{get_model_specs}{gam}(x)

\method{get_model_specs}{ranger}(x)

\method{get_model_specs}{workflow}(x)

\method{get_model_specs}{xgb.Booster}(x)
}
\arguments{
\item{x}{Model object for the model to be explained.}
}
\value{
A list with the following elements:
\describe{
\item{labels}{character vector with the feature names to compute Shapley values for}
\item{classes}{a named character vector with the labels as names and the class type as elements}
\item{factor_levels}{a named list with the labels as names and character vectors with the factor levels as elements
(NULL if the feature is not a factor)}
}
}
\description{
This function is used to extract the feature information from the model to be checked against the
corresponding feature information in the data passed to \code{\link[=explain]{explain()}}.

NOTE: You should never need to call this function explicitly.
It is exported just to be easier accessible for users, see details.
}
\details{
If you are explaining a model not supported natively, you may (optionally) enable such checking by
creating this function yourself and passing it on to \code{\link[=explain]{explain()}}.
}
\examples{
# Load example data
data("airquality")
airquality <- airquality[complete.cases(airquality), ]
# Split data into test- and training data
x_train <- head(airquality, -3)
x_explain <- tail(airquality, 3)
# Fit a linear model
model <- lm(Ozone ~ Solar.R + Wind + Temp + Month, data = x_train)
get_model_specs(model)

}
\seealso{
For model classes not supported natively, you NEED to create an analogue to \code{\link[=predict_model]{predict_model()}}. See it's
help file for details.
}
\author{
Martin Jullum
}
\keyword{internal}
