% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_topline}
\alias{cli_topline}
\title{Create a header topline with cli}
\usage{
cli_topline(verbose, testing, init_time, type, is_python)
}
\arguments{
\item{verbose}{String vector or NULL.
Controls verbosity (printout detail level) via one or more of \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation and messages about parameters/checks.
\code{"progress"} displays where in the calculation process the function currently is.
\code{"convergence"} displays how close the Shapley value estimates are to convergence
(only when \code{iterative = TRUE}).
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE}),
and the final estimates.
\code{"vS_details"} displays information about the v(S) estimates,
most relevant for \code{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac")}.
\code{NULL} means no printout.
Any combination can be used, e.g., \code{verbose = c("basic", "vS_details")}.}

\item{testing}{Logical.
Only used to remove random components, like timing, from the output when comparing with testthat.
Defaults to \code{FALSE}.}

\item{init_time}{POSIXct.
The time when the \code{explain()} function was called, as returned by \code{Sys.time()}.
Used to calculate the total time of the \code{explain()} call.}

\item{type}{Character.
Either "regular" or "forecast", matching the function the call originated from,
and thus the type of explanation to generate.}

\item{is_python}{Logical.
Indicates whether the function is called from the Python wrapper.
Default is FALSE, which is never changed when calling the function via \code{explain()} in R.
The parameter is later used to disallow running the AICc versions of the empirical method,
as that requires data-based optimization, which is not supported in \code{shaprpy}.}
}
\value{
No return value (but prints header with cli unless \code{verbose} is \code{NULL})
}
\description{
Create a header topline with cli
}
\keyword{internal}
