% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domains_info}
\alias{sst_sa_domains_info}
\title{Domains summary}
\usage{
sst_sa_domains_info(
  domains,
  se,
  sort = NULL,
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{domains}{(required) A vector of domain names to analyze.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns aggregated stats for each domain.
}
\description{
Returns the number of keywords for each domain in SEO and
PPC, online visibility and other metrics.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/0c6vx6hzygijk-get-domains-info}{here}.
}

\section{API credits consumption}{
 1 per domain in request.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\examples{
\dontrun{
sst_sa_domains_info(
  domains       = c('amazon.com', 'ebay.com'),
  se            = 'g_us',
  return_method = 'df'
)$data
}
}
