% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{calc_tes}
\alias{calc_tes}
\title{Calculate Term Effectiveness Score}
\usage{
calc_tes(term_analysis, score_name = "tes")
}
\arguments{
\item{term_analysis}{Data frame from term_effectiveness() function}

\item{score_name}{Name for the new score column (default: "tes")}
}
\value{
Data frame with added effectiveness score column
}
\description{
Calculates a balanced effectiveness score for individual search terms
using the harmonic mean of precision and coverage. This provides a
single metric to evaluate how well each term performs in retrieving
relevant articles.
}
\details{
The Term Effectiveness Score (TES) is calculated as:
\deqn{TES = 2 \times \frac{precision \times coverage}{precision + coverage}}

Where:
\itemize{
\item \strong{Precision}: Proportion of retrieved articles that are relevant
\item \strong{Coverage}: Proportion of term-specific relevant articles that were retrieved
}

This differs from the traditional F1 score in that it uses \strong{coverage}
(term-specific relevance) rather than \strong{recall} (overall strategy relevance).

\strong{Key Differences from F1 Score:}
\itemize{
\item \strong{F1 Score}: Precision × Recall (strategy-level performance)
\item \strong{TES}: Precision × Coverage (term-level performance)
\item \strong{Recall}: Relevant articles found / All relevant articles
\item \strong{Coverage}: Relevant articles found / Term-specific relevant articles
}
}
\examples{
# Create sample term analysis
terms <- c("diabetes", "treatment", "clinical")
search_results <- data.frame(
  id = paste0("art", 1:20),
  title = paste("Study on", sample(terms, 20, replace = TRUE)),
  abstract = paste("Research about", sample(terms, 20, replace = TRUE))
)
gold_standard <- paste0("art", c(1, 3, 5, 7, 9))

# Analyze term effectiveness
term_analysis <- term_effectiveness(terms, search_results, gold_standard)

# Calculate effectiveness scores
term_scores <- calc_tes(term_analysis)
print(term_scores[order(term_scores$tes, decreasing = TRUE), ])

}
\seealso{
\code{\link{term_effectiveness}} for calculating term precision and coverage
\code{\link{calc_precision_recall}} for strategy-level F1 scores
}
