% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_scholid_type.R
\name{detect_scholid_type}
\alias{detect_scholid_type}
\title{Detect scholarly identifier types}
\usage{
detect_scholid_type(x)
}
\arguments{
\item{x}{A vector of candidate identifier values.}
}
\value{
A character vector of the same length as \code{x}, giving the detected
identifier type for each element, or \code{NA_character_} if no match is
found.
}
\description{
Performs best-effort detection of scholarly identifier types from possibly
wrapped identifier strings (e.g., URLs or labels).

For each element of the input, the function returns the first matching
identifier type, or \code{NA_character_} if no supported type matches.

Detection first attempts classification based on canonical identifier
syntax (see \code{\link[=classify_scholid]{classify_scholid()}}). If no match is found, the function
attempts per-type normalization (see \code{\link[=normalize_scholid]{normalize_scholid()}}) and returns
the first type for which normalization yields a non-missing result.

Use \code{\link[=normalize_scholid]{normalize_scholid()}} to convert detected values to canonical form
once the identifier type is known.
}
\examples{
detect_scholid_type(c(
  "https://doi.org/10.1000/182",
  "doi:10.1000/182",
  "https://orcid.org/0000-0002-1825-0097",
  "arXiv:2101.12345v2",
  "PMID: 12345678",
  "PMCID: PMC1234567",
  "not an id"
))

}
\seealso{
\code{\link[=classify_scholid]{classify_scholid()}}, \code{\link[=normalize_scholid]{normalize_scholid()}}, \code{\link[=scholid_types]{scholid_types()}}
}
