% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pand.R, R/print.sc_pand.R
\name{pand}
\alias{pand}
\alias{print.sc_pand}
\alias{export.sc_pand}
\title{Percentage of all non-overlapping data}
\usage{
pand(
  data,
  dvar,
  pvar,
  decreasing = FALSE,
  phases = c(1, 2),
  method = c("sort", "minimum")
)

\method{print}{sc_pand}(x, ...)

\method{export}{sc_pand}(object, caption = NA, footnote = NA, filename = NA, round = 1, ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}

\item{method}{Either \code{"sort"}" or \code{"minimum"}. See details.}

\item{x}{An object returned by \code{\link[=pand]{pand()}}}

\item{...}{Further arguments passed to the function.}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{round}{Integer passed to the digits argument used to round values.}
}
\value{
\tabular{ll}{
    \tab  \cr
   \code{pand} \tab Percentage of all non-overlapping data. \cr
   \code{method} \tab Calculation method. \cr
   \code{phi} \tab Effect size Phi based on expected and observed values. \cr
   \code{perc_overlap} \tab Percentage of overlapping data points. \cr
   \code{overlaps} \tab Number of overlapping data points. \cr
   \code{n} \tab Number of data points. \cr
   \code{N} \tab Number of cases. \cr
   \code{n_a} \tab Number of data points in phase A. \cr
   \code{n_b} \tab Number of data points in phase B. \cr
   \code{matrix} \tab 2x2 frequency matrix of phase A and B comparisons. \cr
   \code{matrix_counts} \tab 2x2 counts matrix of phase A and B comparisons. \cr
   \code{chi_test} \tab A Chi-squared analysis of expected and observed data (chisq.test()). \cr
   \code{fisher_test} \tab A Fisher exact test analysis of expected and observed data (fisher.test()). \cr
}
}
\description{
The \code{pand()} function calculates the percentage of all non-overlapping data
(PAND; Parker, Hagan-Burke, & Vannest, 2007), an index to quantify a level
increase (or decrease) in performance after the onset of an intervention.
}
\details{
PAND was proposed by Parker, Hagan-Burke, and Vannest in 2007. The authors
emphasize that PAND is designed for application in a multiple case design with
a substantial number of measurements, technically at least 20 to 25, but
preferably 60 or more. PAND is defined as 100\% minus the percentage of data
points that need to be removed from either phase in order to ensure nonoverlap
between the phases. Several approaches have been suggested to calculate PAND,
leading to potentially different outcomes. In their 2007 paper, Parker and
colleagues present an algorithm for computing PAND. The algorithm involves
sorting the scores of a time series, including the associated phases, and
comparing the resulting phase order with the original phase order using a
contingency table. To account for ties, the algorithm includes a randomization
process where ties are randomly assigned to one of the two phases.
Consequently, executing the algorithm multiple times could yield different
results. It is important to note that this algorithm does not produce the same
results as the PAND definition provided earlier in the same paper. However, it
offers the advantage of allowing the calculation of an effect size measure
\code{phi}, and the application of statistical tests for frequency distributions.
Pustejovsky (2019) presented a mathematical formulation of Parker's original
definition for comparing two phases of a single case: \deqn{PAND =
\frac{1}{m+n}max\{(i+j)I(y^A_{i}<y^B_{n+1-j}\}} This formulation provides
accurate results for PAND, but the original definition has the drawback of an
unknown distribution under the null hypothesis, making a statistical test
difficult. The \code{pand()} function enables the calculation of PAND using both
methods. The first approach (\code{method = "sort"}) follows the algorithm
described above, with the exclusion of randomization before sorting to avoid
ambiguity. It calculates a phi measure and provides the results of a
chi-squared test and a Fisher exact test. The second approach (\code{method = "minimum"}) applies the aforementioned formula. The code of this function is
based on the code of the \code{SingleCaseES} package (function \code{calc_PAND}). For a
multiple case design, overlaps are calculated for each case, summed, and then
divided by the total number of measurements. No statistical test is conducted
for this method.
}
\section{Functions}{
\itemize{
\item \code{print(sc_pand)}: Print results

\item \code{export(sc_pand)}: Export results as html table (see \code{\link[=export]{export()}})

}}
\examples{
## REplication of the Parker et al. 2007 example
pand(Parker2007)

## Calculate the PAND with an expected decrease of phase B scores
cubs <- scdf(c(20,22,24,17,21,13,10,9,20,9,18), B_start = 5)
pand(cubs, decreasing = TRUE)

}
\references{
Parker, R. I., Hagan-Burke, S., & Vannest, K. (2007). Percentage
of All Non-Overlapping Data (PAND): An Alternative to PND. \emph{The Journal of
Special Education, 40}, 194-204.

Parker, R. I., & Vannest, K. (2009). An Improved Effect Size for Single-Case
Research: Nonoverlap of All Pairs. \emph{Behavior Therapy, 40}, 357-367.

Pustejovsky, J. E. (2019). Procedural sensitivities of effect sizes for
single-case designs with directly observed behavioral outcome measures.
\emph{Psychological Methods}, \emph{24(2)}, 217-235.
https://doi.org/10.1037/met0000179

Pustejovsky JE, Chen M, Swan DM (2023). SingleCaseES: A Calculator for
Single-Case Effect Sizes. R package version 0.7.1.9999,
https://jepusto.github.io/SingleCaseES/.
}
\seealso{
Other overlap functions: 
\code{\link{ird}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pem}()},
\code{\link{pet}()},
\code{\link{pnd}()},
\code{\link{print.sc_cdc}()},
\code{\link{tau_u}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
