% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{dispersal}
\alias{dispersal}
\alias{dispersal,samc,missing,location,location,numeric-method}
\alias{dispersal,samc,missing,missing,location,numeric-method}
\alias{dispersal,samc,ANY,missing,location,numeric-method}
\alias{dispersal,samc,missing,missing,missing,missing-method}
\alias{dispersal,samc,missing,location,missing,missing-method}
\alias{dispersal,samc,missing,missing,location,missing-method}
\alias{dispersal,samc,missing,location,location,missing-method}
\alias{dispersal,samc,ANY,missing,missing,missing-method}
\alias{dispersal,samc,ANY,missing,location,missing-method}
\title{Calculate dispersal metrics}
\usage{
dispersal(samc, init, origin, dest, time)

\S4method{dispersal}{samc,missing,location,location,numeric}(samc, origin, dest, time)

\S4method{dispersal}{samc,missing,missing,location,numeric}(samc, dest, time)

\S4method{dispersal}{samc,ANY,missing,location,numeric}(samc, init, dest, time)

\S4method{dispersal}{samc,missing,missing,missing,missing}(samc)

\S4method{dispersal}{samc,missing,location,missing,missing}(samc, origin)

\S4method{dispersal}{samc,missing,missing,location,missing}(samc, dest)

\S4method{dispersal}{samc,missing,location,location,missing}(samc, origin, dest)

\S4method{dispersal}{samc,ANY,missing,missing,missing}(samc, init)

\S4method{dispersal}{samc,ANY,missing,location,missing}(samc, init, dest)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object created using the \code{\link{samc}} function.}

\item{init}{Sets the initial state \eqn{\psi} of the transients states. Input
must be able to pass the \code{\link{check}} function when compared against
the \code{\link{samc-class}} object. Can only contain positive finite values.}

\item{origin}{A positive integer or character name representing transient state
\eqn{\mathit{i}}. Corresponds to row \eqn{\mathit{i}} of matrix \eqn{\mathbf{P}}
in the \code{\link{samc-class}} object. When paired with the \code{dest}
parameter, multiple values may be provided as a vector.}

\item{dest}{A positive integer or character name representing transient state
\eqn{\mathit{j}}. Corresponds to column \eqn{\mathit{j}} of matrix \eqn{\mathbf{P}}
in the \code{\link{samc-class}} object. When paired with the \code{origin} parameter,
multiple values may be provided as a vector.}

\item{time}{A positive integer or a vector of positive integers representing
\eqn{\mathit{t}} time steps. Vectors must be ordered and contain no duplicates.
Vectors may not be used for metrics that return dense matrices. The maximum time
step value is capped at 10,000 due to numerical precision issues.}
}
\value{
See Details
}
\description{
Calculates the probability of individuals visiting locations
}
\details{
\eqn{\tilde{D}_{jt}=(\sum_{n=0}^{t-1}\tilde{Q}^n)\tilde{q}_j}
\itemize{
    \item \strong{dispersal(samc, dest, time)}

The result is a vector \eqn{\mathbf{v}} where \eqn{\mathbf{v}_i} is the probability
of visiting transient state \eqn{\mathit{j}} within \eqn{\mathit{t}} or fewer
time steps if starting at transient state \eqn{\mathit{i}}.

Note: Given the current derivation, when \eqn{\mathit{i=j}}, then \eqn{\mathbf{v}_i}
is unknown and has been set to \code{NA}.

If multiple time steps were provided as a vector, then the result will be an
ordered named list containing a vector for each time step.

If the samc-class object was created using matrix or RasterLayer maps, then
vector \eqn{\mathbf{v}} can be mapped to a RasterLayer using the
\code{\link{map}} function.
}

\eqn{\psi^T\tilde{D}_{jt}}
\itemize{
    \item \strong{dispersal(samc, init, dest, time)}

The result is a numeric that is the probability of visiting transient state \eqn{\mathit{j}}
within \eqn{\mathit{t}} or fewer time steps given an initial state \eqn{\psi}

If multiple time steps were provided as a vector, then the result will be an
ordered named list containing a vector for each time step.
}

\eqn{D=(F-I)diag(F)^{-1}}
\itemize{
    \item \strong{dispersal(samc)}

The result is a matrix \eqn{M} where \eqn{M_{i,j}} is the probability of visiting
transient state \eqn{\mathit{j}} if starting at transient state \eqn{\mathit{i}}.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use (see \code{\link{samc-class}}).

    \item \strong{dispersal(samc, origin)}

The result is a vector \eqn{\mathbf{v}} where \eqn{\mathbf{v}_j} is the probability
of visiting transient state \eqn{\mathit{j}} if starting at transient state \eqn{\mathit{i}}.

If the samc-class object was created using matrix or RasterLayer maps, then
vector \eqn{\mathbf{v}} can be mapped to a RasterLayer using the
\code{\link{map}} function.

    \item \strong{dispersal(samc, dest)}

The result is a vector \eqn{\mathbf{v}} where \eqn{\mathbf{v}_i} is the probability
of visiting transient state \eqn{\mathit{j}} if starting at transient state \eqn{\mathit{i}}.

If the samc-class object was created using matrix or RasterLayer maps, then
vector \eqn{\mathbf{v}} can be mapped to a RasterLayer using the
\code{\link{map}} function.

    \item \strong{dispersal(samc, origin, dest)}

The result is a numeric value that is the probability of visiting transient
state \eqn{\mathit{j}} if starting at transient state \eqn{\mathit{i}}.
}

\eqn{\psi^TD}
\itemize{
    \item \strong{dispersal(samc, init)}

The result is a vector \eqn{\mathbf{v}} where \eqn{\mathbf{v}_j} is the probability
of visiting transient state \eqn{\mathit{j}} given an initial state \eqn{\psi}.

If the samc-class object was created using matrix or RasterLayer maps, then
vector \eqn{\mathbf{v}} can be mapped to a RasterLayer using the
\code{\link{map}} function.

    \item \strong{dispersal(samc, init, dest)}

The result is a numeric value that is the probability of visiting transient
state \eqn{\mathit{j}} given an initial state \eqn{\psi}.
}
}
\section{Performance}{


Performance details are in the performance vignette:
\code{vignette("performance", package = "samc")}.
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::example_split_corridor$res
abs_data <- samc::example_split_corridor$abs
init_data <- samc::example_split_corridor$init


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, init_data)

# Setup the details for a random-walk model
rw_model <- list(fun = function(x) 1/mean(x), # Function for calculating transition probabilities
                 dir = 8, # Directions of the transitions. Either 4 or 8.
                 sym = TRUE) # Is the function symmetric?


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers.
samc_obj <- samc(res_data, abs_data, model = rw_model)


# Convert the initial state data to probabilities
init_prob_data <- init_data / sum(init_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, init_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, init_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
