% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_player_boxscore}
\alias{load_player_boxscore}
\title{Load cleaned player boxscore data from the volleydata repository.}
\usage{
load_player_boxscore(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing player boxscore data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab int \cr
   season \tab int \cr
   match_datetime \tab chr \cr
   team_involved \tab chr \cr
   team_name \tab chr \cr
   player_name \tab chr \cr
   last_name \tab chr \cr
   first_name \tab chr \cr
   sets_played \tab int \cr
   player_number \tab chr \cr
   is_captain \tab lgl \cr
   is_libero \tab int \cr
   set_starting_position \tab chr \cr
   set_number \tab int \cr
   serves \tab int \cr
   serve_errors \tab int \cr
   serve_aces \tab int \cr
   serve_efficiency \tab dbl \cr
   attack_attempts \tab int \cr
   attack_errors \tab int \cr
   attack_kills \tab int \cr
   attack_success_ratio \tab dbl \cr
   attack_efficiency \tab dbl \cr
   receptions \tab int \cr
   reception_errors \tab int \cr
   positive_reception_ratio \tab dbl \cr
   perfect_reception_ratio \tab dbl \cr
   block_points \tab int \cr
   block_touches \tab int \cr
   earned_points \tab int \cr
   net_points \tab int \cr
   assists \tab int \cr
   successful_digs \tab int \cr
   id \tab chr \cr
   spike_hp \tab int \cr
   points \tab int \cr
   league \tab chr \cr
}
}
\description{
Load cleaned player boxscore data from the volleydata repository.
}
\examples{
\donttest{try({load_player_boxscore("mlv", 2024)})}
}
