% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dchisq_rvec}
\alias{dchisq_rvec}
\alias{pchisq_rvec}
\alias{qchisq_rvec}
\alias{rchisq_rvec}
\title{Chi-Squared Distribution, Using Multiple Draws}
\usage{
dchisq_rvec(x, df, ncp = 0, log = FALSE)

pchisq_rvec(q, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qchisq_rvec(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rchisq_rvec(n, df, ncp = 0, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{df}{Degrees of freedom.
See \code{\link[=dchisq]{dchisq()}}.
Can be an rvec.}

\item{ncp}{Non-centrality parameter.
Default is \code{0}. Cannot be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
chi-squared distribution, modified to work with
rvecs.
}
\details{
Functions \code{dchisq_rvec()}, \code{pchisq_rvec()},
\code{pchisq_rvec()} and \code{rchisq_rvec()} work like
base R functions \code{\link[=dchisq]{dchisq()}}, \code{\link[=pchisq]{pchisq()}},
\code{\link[=qchisq]{qchisq()}}, and \code{\link[=rchisq]{rchisq()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rchisq_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dchisq_rvec()}, \code{pchisq_rvec()},
\code{pchisq_rvec()} and \code{rchisq_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3, 5.1),
               c(0.1, 2.3)))
dchisq_rvec(x, df = 3)
pchisq_rvec(x, df = 3)

rchisq_rvec(n = 2,
            df = 3:4,
            n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dchisq]{dchisq()}}, \code{\link[=pchisq]{pchisq()}}, \code{\link[=qchisq]{qchisq()}}, \code{\link[=rchisq]{rchisq()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
