% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffMRM.R
\name{getMRMChromatograms}
\alias{getMRMChromatograms}
\title{Extract full chromatograms for each mass transition}
\usage{
getMRMChromatograms(scanfile, tic, sample)
}
\arguments{
\item{scanfile}{A file path to a Sciex raw scan file (extension .wiff.scan)
containing the raw data referenced by the .wiff file from which the other
parameters were extracted}

\item{tic}{A total ion chromatogram data.frame as extracted by \code{\link[=getTIC]{getTIC()}} or
\code{\link[=getAllTIC]{getAllTIC()}}}

\item{sample}{A "sample" object representing a run in a .wiff file, from the
\code{samples} field of an \code{rtmsWiffReader} object, containing information about
the mass transitions measured in that run}
}
\value{
A single data frame expressing all chromatograms in a "long" format,
with the following columns:
\itemize{
\item \code{massindex}: The index of the measured mass transition in the set of masses
in the given sample
\item \code{mass}: The name of the mass transition measured (often a compound name or
id)
\item \code{time}: The time (in seconds) at which the intensity was measured
\item \code{intensity}: The intensity for the given mass transition at the given time
}
}
\description{
Extract full chromatograms for each mass transition
}
