% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSVDdpd.R
\name{rank.rSVDdpd}
\alias{rank.rSVDdpd}
\title{Rank Estimation for Robust Singular Value Decomposition}
\usage{
rank.rSVDdpd(X, alpha = 0.5, maxrank = NULL)
}
\arguments{
\item{X}{\code{matrix}, the data matrix for which robust rank estimation is required.}

\item{alpha}{\code{numeric}, robustness parameter between 0 and 1 (default \code{0.5}).
Controls the trade-off between robustness and efficiency in the DPD measure.}

\item{maxrank}{\code{integer}, maximum rank to be considered. Defaults to
\code{min(dim(X))}.}
}
\value{
A named integer vector of length 3, giving the estimated ranks according
  to each criterion:
  \itemize{
    \item \code{DIC} — estimated rank from DIC.
    \item \code{RCC} — estimated rank from RCC.
    \item \code{DICMR} — estimated rank from DICMR (recommended).
  }
}
\description{
\code{rank.rSVDdpd} estimates the optimal rank of a given matrix under
robust SVD using Density Power Divergence (DPD) criteria.
}
\details{
The function computes three penalized criteria for rank determination:
\itemize{
  \item \strong{DIC} — Divergence Information Criterion.
  \item \strong{RCC} — Robust Cross-Validation Criterion.
  \item \strong{DICMR} — Modified Divergence Information Criterion with Matrix Rank
    penalty (recommended).
}

The function computes a full robust SVD (up to \code{maxrank}) using
  \code{\link{rSVDdpd}}. It then evaluates the DPD divergence at different
  candidate ranks and applies penalty adjustments for model complexity.
  The final estimated rank minimizes the penalized criterion.
}
\examples{
X <- matrix(rnorm(100), 10, 10)
rank.rSVDdpd(X, alpha = 0.3, maxrank = 5)
}
\seealso{
\code{\link{rSVDdpd}}, \code{\link{svd}}
}
