% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployDoc.R
\name{deployDoc}
\alias{deployDoc}
\title{Deploy a single document}
\usage{
deployDoc(doc, ..., logLevel = c("normal", "quiet", "verbose"))
}
\arguments{
\item{doc}{Path to the document to deploy.}

\item{...}{Additional arguments to \code{\link[=deployApp]{deployApp()}}. Do not supply \code{appDir},
\code{appFiles}, or \code{appPrimaryDoc}; these three parameters are automatically
generated by \code{deployDoc} from the document.}

\item{logLevel}{One of \code{"quiet"}, \code{"normal"} or \code{"verbose"}; indicates how
much logging to the console is to be performed. At \code{"quiet"} reports no
information; at \code{"verbose"}, a full diagnostic log is captured.}
}
\description{
Deploys a single R Markdown, Quarto document, or other file (e.g. \code{.html} or
\code{.pdf}).

When deploying an \code{.Rmd}, \code{.Qmd}, or \code{.html}, \code{deployDoc()} will attempt to
automatically discover dependencies using \code{\link[rmarkdown:find_external_resources]{rmarkdown::find_external_resources()}},
and include an \code{.Rprofile} if present. If you find that the document is
missing dependencies, either specify the dependencies explicitly in the
document (see \code{\link[rmarkdown:find_external_resources]{rmarkdown::find_external_resources()}} for details), or call
\code{\link[=deployApp]{deployApp()}} directly and specify your own file list in \code{appFiles}.

Supported servers: All servers
}
\examples{
\dontrun{
deployDoc("my-report.Rmd")
deployDoc("static-file.html")
}
}
\seealso{
Other Deployment functions: 
\code{\link{applications}()},
\code{\link{deployAPI}()},
\code{\link{deployApp}()},
\code{\link{deploySite}()},
\code{\link{deployTFModel}()}
}
\concept{Deployment functions}
