% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_data_frame.R
\name{rquery_apply_to_data_frame}
\alias{rquery_apply_to_data_frame}
\title{Execute optree in an environment where d is the only data.}
\usage{
rquery_apply_to_data_frame(
  d,
  optree,
  ...,
  limit = NULL,
  source_limit = NULL,
  allow_executor = TRUE,
  env = parent.frame()
)
}
\arguments{
\item{d}{data.frame or named list of data.frames.}

\item{optree}{rquery rel_op operation tree.}

\item{...}{force later arguments to bind by name.}

\item{limit}{integer, if not NULL limit result to no more than this many rows.}

\item{source_limit}{numeric if not NULL limit sources to this many rows.}

\item{allow_executor}{logical if TRUE allow any executor set as rquery.rquery_executor to be used.}

\item{env}{environment to look to.}
}
\value{
data.frame result
}
\description{
Default DB uses RSQLite (so some functions are not supported).
}
\examples{

# WARNING: example tries to change rquery.rquery_db_executor option to RSQLite and back.
if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(db)
  old_o <- options(list("rquery.rquery_db_executor" = list(db = db)))

  optree <- mk_td("d", c("AUC", "R2", "D")) \%.>\%
  	extend(., c \%:=\% sqrt(R2)) \%.>\%
    orderby(., cols = "R2", reverse = "R2")

  d <- data.frame(AUC = 0.6, R2 = c(0.1, 0.2), D = NA, z = 2)
  v <- rquery_apply_to_data_frame(d, optree)
  print(v)

  # now load up a table without an R2 column,
  # want to show this is caught
  d <- data.frame(z = 1)
  tryCatch(
     rquery_apply_to_data_frame(d, optree),
     error = function(e) { as.character(e) }
    ) \%.>\%
    print(.)

  options(old_o)
  DBI::dbDisconnect(db)
}

}
