% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_compile.r
\name{compile}
\alias{compile}
\title{Generate Executable Code}
\arguments{
\item{sources}{Name(s) of source files(s) where functions appearing in
process rates or stoichiometric factors are implemented. Can be \code{NULL}
if no external functions are required, the name of a single file, or a
vector of file names. See notes below.}

\item{fortran}{If \code{TRUE}, Fortran code is generated and compiled into a shared
library. If \code{FALSE}, R code is generated. The default was changed from
\code{TRUE} to \code{FALSE} in package version 0.8.6).}

\item{target}{Name of a 'target environment'. Currently, 'deSolve' is the
only supported value.}

\item{lib}{File path to be used for the generated library (without
the platform specific extension). Note that any uppercase characters will
be converted to lowercase. By default, the file is created in R's
temporary folder under a random name.}

\item{reuse}{If \code{TRUE}, an already existing library file will be loaded.
Use this to prevent
unnecessary re-compilation but note that R is likely to crash in case
of any mismatches between the object and the existing library. Default is
\code{FALSE}, i.e. the library is unconditionally build from scratch.}
}
\value{
\code{invisible(NULL)}
}
\description{
Creates and 'compiles' a function for use with numerical methods from
package \code{\link[deSolve]{deSolve}} or \code{\link[rootSolve]{rootSolve}}.
}
\note{
The expected language of the external code passed in \code{sources}
  depends on the value of \code{fortran}.

  If \code{fortran} is \code{FALSE}, R code is generated and made executable
  by \code{\link[base]{eval}} and \code{\link[base]{parse}}. Auxiliary code
  passed via \code{sources} is made available via \code{\link[base]{source}}.
  The created R function is stored in the object.

  If \code{fortran} is \code{TRUE}, the external code passed in 
  \code{sources} must implement a module with the fixed name 'functions'.
  This module must contain all user-defined functions referenced in process
  rates or stoichiometric factors. The file names passed to the
  \code{sources} argument must carry an extension which is recognized by
  the compiler as a source file. Something like ".f95" should work.

  If \code{fortran} is \code{TRUE}, a shared library is created. The library
  is immediately loaded with \code{\link[base]{dyn.load}} and it is
   automatically unloaded with \code{\link[base]{dyn.unload}} when the
  object's \code{\link{finalize}} method is called.
  
  The name of the library (base name without extension) as well as the name
  of the function to compute the  derivatives are stored in the object.
  These names can be queried with the
  \code{\link{libName}} and \code{\link{libFunc}} methods, respectively.
  Unless a file path is specified via the \code{lib} argument, the library is
  created in the folder returned by \code{\link[base]{tempdir}} under a
  unique random name.
}
\examples{
data(vars, pars, funs, pros, stoi)
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
# This would trigger compilation assuming that 'functionsCode.f95' contains
# a Fortran implementation of all functions; see vignette for full example
\dontrun{
model$compile(sources="functionsCode.f95")
}
}
\seealso{
This method internally calls \code{\link{generate}}.
}
\author{
\email{david.kneis@tu-dresden.de}
}
