% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constSum.R
\name{constSum}
\alias{constSum}
\title{Constant sum}
\usage{
constSum(x, const = 1, na.rm = TRUE)
}
\arguments{
\item{x}{multivariate data ideally of class data.frame or matrix}

\item{const}{constant, the default equals 1.}

\item{na.rm}{removing missing values.}
}
\value{
The data for which the row sums are equal to \code{const}.
}
\description{
Closes compositions to sum up to a given constant (default 1), by dividing
each part of a composition by its row sum.
}
\examples{

data(expenditures)
constSum(expenditures)
constSum(expenditures, 100)

}
\author{
Matthias Templ
}
\keyword{manip}
