% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archaeology.R
\name{road_get_miscellaneous_finds}
\alias{road_get_miscellaneous_finds}
\title{Get miscellaneous finds from the ROAD database}
\usage{
road_get_miscellaneous_finds(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  miscellaneous_find_material = NULL,
  assemblages = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe). 
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated 
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")} 
to display possible values.
The argument \code{country} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the 
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age 
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")} 
to display possible values. The argument \code{cultural_period} is a string 
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool 
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes 
human remains, raw material, typology, technology, function, organic tools, 
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains, 
plant remains. The argument \code{category} is a string (one item) or 
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{miscellaneous_find_material}{specifies material of the miscellaneous 
finds (e.g. shell, ochre, ostrich eggshell).
Run \code{road_list_argument_values("miscellaneous_find_material")} to 
display possible values. The argument \code{miscellaneous_find_material} is 
a string (one item) or vector of strings; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}
}
\value{
A data frame with information about miscellaneous finds. Rows represent individual finds, columns contain details on:

\code{miscellaneous find material}: Material of the miscellaneous 
find. Some examples: beeswax, bitumen, clay, flax fiber, fossil, mineral 
diverse (materials such as crystals), mineral pigment (colorants such as 
ochre, hematite, limonite, goethite, specularite, etc.) ostrich eggshell

\code{miscellaneous find material source}: List with specific 
intervals of transport for the raw material used to manufacture the 
miscellaneous finds. Five fixed types of material source are possible:
\itemize{
  \item local (0-5 km) 
  \item regional (6-20 km)
  \item supra-regional (21-100 km)
  \item distant (>100 km)
  \item unknown
}

\code{number}: Number of individual pieces of a given material present
 in an assemblage with miscellaneous finds.
}
\description{
The \strong{\code{road_get_miscellaneous_finds}} retrieves data of miscellaneous finds from the ROAD database.
Miscellaneous finds are archaeological objects that do not fit into other specific categories.
Miscellaneous finds are classified by their material.
This function allows you to query miscellaneous finds data from the ROAD database
using parameters such as geographical location,
cultural periods, material types, and assemblages. Use the parameters to filter the results
or omit them to retrieve a broader dataset.
}
\examples{
\donttest{road_get_miscellaneous_finds(country = "Sudan", miscellaneous_find_material = "wood fossil")}
\donttest{road_get_miscellaneous_finds(continent = c("Africa"), locality_type = "open air",
                             miscellaneous_find_material = "shell")}
}
