% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_localities.R
\name{road_get_localities}
\alias{road_get_localities}
\title{Get localities from the ROAD Database}
\usage{
road_get_localities(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument\code{continent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe).
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")}
to display possible values.
The argument \code{country} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")}
to display possible values. The argument \code{cultural_period} is a string
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes
human remains, raw material, typology, technology, function, organic tools,
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains,
plant remains. The argument \code{category} is a string (one item) or
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}
}
\value{
A data frame with location information. Rows represent individual locations, columns contain location-related details on:

\code{continent}, \code{subcontinent}, \code{country}: The attributes specify the geopolitical information of the locality.

\code{locality_type}: The attribute specifies the type of locality (e.g. cave, rockshelter, open air).

\code{coord_x}, \code{coord_y}: The attributes specify the geographic coordinates (longitude and latitude) of the locality.

\code{coordination_source}: The attribute  contains information about the source of coordinates for a locality.

\code{category}: Specifies the category of the findings associated with the locality. If there are multiple, they are returned in a comma separated list.

\code{cultural_period}: Specifies the cultural epoch(s) associated with the locality. If there are multiple, they are returned in a comma separated list.

\code{technocomplex}: Specifies the archaeological culture or named stone tool industry associated with the locality. If there are multiple, they are returned in a comma separated list.

\code{subset_age_min}, \code{subset_age_max}: The attributes specify the minimum and maximum age of all assemblages associated with the locality that match the search criteria.

\code{locality_age_min}, \code{locality_age_max}: The attributes specify the overall minimum and maximum age of all assemblages associated with this locality.
}
\description{
The \strong{\code{road_get_localities}} funrction retrieves data of archaeological
sites (localities) from the ROAD database. The ROAD table locality provides basic
information about each location where an assemblage of archaeological,
paleoanthropological, paleontological, paleobotanical or other relevant material
was described, recorded, sampled or collected. Every locality (site) is
situated in a specific country within a given geographic region. The name of every
locality is unique.
}
\details{
Use parameters to filter search results by location, type, or culture or omit
them to have a broader result set. All parameters are optional and should be
omitted or set to NULL when not used.
}
\examples{
\donttest{road_get_localities(continent = "Europe",
                    locality_type = c("basin", "quarry"))}
\donttest{road_get_localities(country = c("Germany","Austria"),
                    cultural_period = "Epipaleolithic")}
}
