#' Convert R code to a character vector of shell commands evaluating the given R code.
#'
#' The function takes R commands, deparses them, substitutes existing variables, and converts
#' everything to character strings, from which a shell command is created that sends the given
#' R code to the R interpreter. The function is used internally to print the commands of R rules
#' into the `Makefile`.
#'
#' @param ... R commands to be converted
#' @return A character vector of shell commands that send the given R code by pipe to the R
#' interpreter
#' @author Michal Burda
#' @seealso [rRule()], [markdownRule()]
#' @examples
#' inShell({
#'   x <- 1
#'   y <- 2
#'   print(x+y)
#' })
#' @export
inShell <- function(...) {
  pf <- as.list(parent.frame())
  theDots <- eval(substitute(alist(...)))

  exprs <- lapply(theDots, function(e) {
    call <- substitute(substitute(e, pf), list(e=e))
    eval(call)
  })

  ctrl <- c('keepInteger', 'showAttributes', 'useSource', 'warnIncomplete', 'keepNA')
  if (getRversion() > '3.4.4') {
    ctrl <- c(ctrl, 'niceNames')
  }
  exprs <- lapply(exprs, function(e) {
    deparse(e,
            width.cutoff=500L,
            control=ctrl)
  })

  exprs <- unlist(exprs)
  if (length(exprs) > 0) {
    last <- length(exprs)
    notLast <- seq_len(last-1)
    exprs <- encodeString(exprs)
    exprs <- paste0('-e \'', exprs, '\'')
    exprs[1] <- paste0('$(R) ', exprs[1])
    exprs[notLast] <- paste0(exprs[notLast], ' \\')
  }
  exprs
}

