% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5Utility.R
\name{writeH5}
\alias{writeH5}
\alias{writeH5.default}
\alias{writeH5.dgCMatrix}
\alias{writeH5.ligerDataset}
\alias{writeH5.liger}
\title{Write in-memory data into H5 file}
\usage{
writeH5(x, file, ...)

\method{writeH5}{default}(x, file, ...)

\method{writeH5}{dgCMatrix}(
  x,
  file,
  overwrite = FALSE,
  indicesPath = "matrix/indices",
  indptrPath = "matrix/indptr",
  dataPath = "matrix/data",
  shapePath = "matrix/shape",
  barcodesPath = "matrix/barcodes",
  featuresPath = "matrix/features/name",
  ...
)

\method{writeH5}{ligerDataset}(x, file, ...)

\method{writeH5}{liger}(x, file, useDatasets, ...)
}
\arguments{
\item{x}{An object with in-memory data to be written into H5 file.}

\item{file}{A character string of the file path to be written.}

\item{...}{Arguments passed to other S3 methods.}

\item{overwrite}{Logical, whether to overwrite the file if it already exists.
Default \code{FALSE}.}

\item{indicesPath, indptrPath, dataPath}{The paths inside the H5 file where
the \link[Matrix]{dgCMatrix-class} constructor \code{i}, \code{p}, and
\code{x} will be written to, respectively. Default using cellranger
convention \code{"matrix/indices"}, \code{"matrix/indptr"}, and
\code{"matrix/data"}.}

\item{shapePath}{The path inside the H5 file where the shape of the matrix
will be written to. Default \code{"matrix/shape"}.}

\item{barcodesPath}{The path inside the H5 file where the barcodes/colnames
will be written to. Default \code{"matrix/barcodes"}. Skipped if the object
does not have colnames.}

\item{featuresPath}{The path inside the H5 file where the features/rownames
will be written to. Default \code{"matrix/features/name"}. Skipped if the
object does not have rownames.}

\item{useDatasets}{For liger method. Names or indices of datasets to be
written to H5 files. Required.}
}
\value{
Nothing is returned. H5 file will be created on disk.
}
\description{
This function writes in-memory data into H5 file by default in 10x cellranger
HDF5 output format. The main goal of this function is to allow users to
integrate large H5-based dataset, that cannot be fully loaded into memory,
with other data already loaded in memory using \code{\link{runOnlineINMF}}.
In this case, users can write the smaller in-memory data to H5 file instead
of loading subset of the large H5-based dataset into memory, where
information might be lost.

Basing on the goal of the whole workflow, the data will always be written
in a CSC matrix format and colnames/rownames are always required.

The default method coerces the input to a \link[Matrix]{dgCMatrix-class}
object. Methods for other container classes tries to extract proper data and
calls the default method.
}
\examples{
raw <- rawData(pbmc, "ctrl")
writeH5(raw, tempfile(pattern = "ctrl_", fileext = ".h5"))
}
\seealso{
\href{https://www.10xgenomics.com/cn/support/software/cell-ranger/latest/analysis/outputs/cr-outputs-h5-matrices}{10X cellranger H5 matrix detail}
}
