% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotVolcano}
\alias{plotVolcano}
\title{Create volcano plot for Wilcoxon test result}
\usage{
plotVolcano(
  result,
  group = NULL,
  logFCThresh = 1,
  padjThresh = 0.01,
  highlight = NULL,
  labelTopN = NULL,
  dotSize = 2,
  dotAlpha = 0.8,
  legendPosition = "top",
  labelSize = 4,
  ...
)
}
\arguments{
\item{result}{Data frame table returned by \code{\link{runMarkerDEG}} or
\code{\link{runPairwiseDEG}}.}

\item{group}{Selection of one group available from \code{result$group}. If
only one group is available from \code{result}, default \code{NULL} uses it.}

\item{logFCThresh}{Number for the threshold on the absolute value of the log2
fold change statistics. Default \code{1}.}

\item{padjThresh}{Number for the threshold on the adjusted p-value
statistics. Default \code{0.01}.}

\item{highlight}{A character vector of feature names to be highlighted.
Default \code{NULL}.}

\item{labelTopN}{Number of top differential expressed features to be labeled
on the top of the dots. Ranked by adjusted p-value first and absolute value
of logFC next. Default \code{NULL}.}

\item{dotSize, dotAlpha}{Numbers for universal aesthetics control of dots.
Default \code{2} and \code{0.8}.}

\item{legendPosition}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"top"}.}

\item{labelSize}{Size of labeled top features and line annotations. Default
\code{4}.}

\item{...}{
  Arguments passed on to \code{\link[=.ggScatter]{.ggScatter}}, \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{dotOrder}}{Controls the order that each dot is added to the plot. Choose
from \code{"shuffle"}, \code{"ascending"}, or \code{"descending"}. Default
\code{"shuffle"}, useful when coloring by categories that overlaps (e.g.
"dataset"), \code{"ascending"} can be useful when coloring by a continuous
variable (e.g. gene expression) where high values needs more
highlight. \code{NULL} use default order.}
    \item{\code{raster}}{Logical, whether to rasterize the plot. Default \code{NULL}
automatically rasterize the plot when number of total dots to be plotted
exceeds 100,000.}
    \item{\code{labelText}}{Logical, whether to show text label at the median position
of each categorical group specified by \code{colorBy}. Default \code{TRUE}.
Does not work when continuous coloring is specified.}
    \item{\code{labelTextSize}}{Numeric, controls the size of label size when
\code{labelText = TRUE}. Default \code{4}.}
    \item{\code{seed}}{Random seed for reproducibility. Default \code{1}.}
    \item{\code{legendColorTitle}}{Legend title text for color aesthetics, often used
for categorical or continuous coloring of dots. Default \code{NULL} shows the
original variable name.}
    \item{\code{showLegend}}{Whether to show the legend. Default \code{TRUE}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{titleSize,xTitleSize,yTitleSize,legendTitleSize}}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}
    \item{\code{subtitleSize,xTextSize,yTextSize,legendTextSize}}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
  }}
}
\value{
ggplot
}
\description{
\code{plotVolcano} is a simple implementation and shares most of arguments
with other rliger plotting functions. \code{plotEnhancedVolcano} is a
wrapper function of \code{EnhancedVolcano::EnhancedVolcano()}, which has
provides substantial amount of arguments for graphical control. However, that
requires the installation of package "EnhancedVolcano".

\code{highlight} and \code{labelTopN} both controls the feature name
labeling, whereas \code{highlight} is considered first. If both are as
default (\code{NULL}), all significant features will be labeled.
}
\examples{
plotVolcano(deg.pw, "stim.CD14 Mono")
}
