% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{.plotHeatmap}
\alias{.plotHeatmap}
\title{General heatmap plotting with prepared matrix and data.frames}
\usage{
.plotHeatmap(
  dataMatrix,
  dataName = "Value",
  cellDF = NULL,
  featureDF = NULL,
  transpose = FALSE,
  cellSplitVar = NULL,
  featureSplitVar = NULL,
  dataScaleFunc = NULL,
  showCellLabel = FALSE,
  showCellLegend = TRUE,
  showFeatureLabel = TRUE,
  showFeatureLegend = TRUE,
  cellAnnColList = NULL,
  featureAnnColList = NULL,
  scale = FALSE,
  trim = c(-2, 2),
  baseSize = 8,
  cellTextSize = NULL,
  featureTextSize = NULL,
  cellTitleSize = NULL,
  featureTitleSize = NULL,
  legendTextSize = NULL,
  legendTitleSize = NULL,
  viridisOption = "A",
  viridisDirection = -1,
  RColorBrewerOption = "RdBu",
  ...
)
}
\arguments{
\item{dataMatrix}{Matrix object with features/factors as rows and cells as
columns.}

\item{dataName}{Text for heatmap color bar title. Default \code{Value}.}

\item{cellDF}{data.frame object. Number of rows must match with number of
columns of \code{dataMatrix}.}

\item{featureDF}{data.frame object. Number of columns must match with number
of rows of \code{dataMatrix}.}

\item{transpose}{Logical, whether to "rotate" the heatmap by 90 degrees so
that cell information is displayed by row. Default \code{FALSE}.}

\item{cellSplitVar, featureSplitVar}{Subset columns of \code{cellDF} or
\code{featureDF}, respectively.}

\item{dataScaleFunc}{A function object, applied to \code{dataMatrix}.}

\item{showCellLabel, showFeatureLabel}{Logical, whether to show cell barcodes,
gene symbols or factor names. Default \code{TRUE} for gene/factors but
\code{FALSE} for cells.}

\item{showCellLegend, showFeatureLegend}{Logical, whether to show cell or
feature legends. Default \code{TRUE}. Can be a scalar for overall control
or a vector matching with each given annotation variable.}

\item{cellAnnColList, featureAnnColList}{List object, with each element a
named vector of R-interpretable color code. The names of the list elements
are used for matching the annotation variable names. The names of the colors
in the vectors are used for matching the levels of a variable (factor object,
categorical). Default \code{NULL} generates ggplot-flavor categorical colors.}

\item{scale}{Logical, whether to take z-score to scale and center gene
expression. Applied after \code{dataScaleFunc}. Default \code{FALSE}.}

\item{trim}{Numeric vector of two values. Limit the z-score value into this
range when \code{scale = TRUE}. Default \code{c(-2, 2)}.}

\item{baseSize}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}

\item{cellTextSize, featureTextSize, legendTextSize}{Size of cell barcode
labels, gene/factor labels, or legend values. Default \code{NULL}.}

\item{cellTitleSize, featureTitleSize, legendTitleSize}{Size of titles of the
cell slices, gene/factor slices, or the legends. Default \code{NULL}.}

\item{viridisOption, viridisDirection}{See argument \code{option} and
\code{direction} of \code{\link[viridisLite]{viridis}}. Default \code{"A"}
and \code{-1}.}

\item{RColorBrewerOption}{When \code{scale = TRUE}, heatmap color will be
mapped with \code{\link[RColorBrewer]{brewer.pal}}. This is passed to
\code{name}. Default \code{"RdBu"}.}

\item{...}{Additional arguments to be passed to
\code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
\code{\link[ComplexHeatmap]{HeatmapList-class}} object
}
\description{
This is not an exported function. This documentation just
serves for a manual of extra arguments that users can use when generating
heatmaps with \code{\link{plotGeneHeatmap}} or
\code{\link{plotFactorHeatmap}}.

Note that the following arguments are pre-occupied by upstream wrappers so
users should not include them in a function call: \code{dataMatrix},
\code{dataName}, \code{cellDF}, \code{featureDF}, \code{cellSplitVar},
\code{featureSplitVar}.

The following arguments of \code{\link[ComplexHeatmap]{Heatmap}} is occupied
by this function, so users should include them in a function call as well:
\code{matrix}, \code{name}, \code{col}, \code{heatmap_legend_param},
\code{top_annotation}, \code{column_title_gp}, \code{column_names_gp},
\code{show_column_names}, \code{column_split}, \code{column_gap},
\code{left_annotation}, \code{row_title_gp}, \code{row_names_gp},
\code{show_row_names}, \code{row_split}, \code{row_gap}.
}
