/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information.formatters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.InformationSet;
import jdplus.toolkit.base.api.information.formatters.BooleanFormatter;
import jdplus.toolkit.base.api.information.formatters.ComplexFormatter;
import jdplus.toolkit.base.api.information.formatters.DiagnosticFormatter;
import jdplus.toolkit.base.api.information.formatters.DoubleFormatter;
import jdplus.toolkit.base.api.information.formatters.InformationFormatter;
import jdplus.toolkit.base.api.information.formatters.IntegerFormatter;
import jdplus.toolkit.base.api.information.formatters.LongFormatter;
import jdplus.toolkit.base.api.information.formatters.ParameterFormatter;
import jdplus.toolkit.base.api.information.formatters.PeriodFormatter;
import jdplus.toolkit.base.api.information.formatters.RegressionItemFormatter;
import jdplus.toolkit.base.api.information.formatters.StatisticalTestFormatter;
import jdplus.toolkit.base.api.information.formatters.StringArrayFormatter;
import jdplus.toolkit.base.api.information.formatters.StringFormatter;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;
import lombok.Generated;

public final class MatrixFormatter {
    private static final HashMap<Class, InformationFormatter> DICTIONARY = new HashMap();
    private static Locale LOCALE;

    public static boolean canProcess(Class cl) {
        return DICTIONARY.containsKey(cl);
    }

    public static String[] formatInformation(List<InformationSet> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split(name));
        }
        int[] witems = new int[snames.size()];
        int icur = 0;
        for (String[] sname : snames) {
            Iterator<InformationSet> slast = sname[sname.length - 1];
            int l = ((String)((Object)slast)).indexOf(58);
            witems[icur] = 1;
            if (l >= 0) {
                String s0 = ((String)((Object)slast)).substring(0, l);
                String s1 = ((String)((Object)slast)).substring(l + 1);
                int w = 0;
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                    witems[icur] = w;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++icur;
        }
        ArrayList<String> rslt = new ArrayList<String>();
        int i = 0;
        for (String[] cnames : snames) {
            if (shortname) {
                rslt.add(cnames[cnames.length - 1]);
            } else {
                rslt.add(names.get(i));
            }
            for (int j = 1; j < witems[i]; ++j) {
                rslt.add("");
            }
        }
        for (InformationSet record : records) {
            i = 0;
            for (String[] cnames : snames) {
                int j;
                int n = witems[i];
                Object obj = record.search(cnames, Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.add(MatrixFormatter.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.add(MatrixFormatter.format(obj, -n));
                        continue;
                    }
                    for (j = 1; j <= n; ++j) {
                        rslt.add(MatrixFormatter.format(obj, j));
                    }
                    continue;
                }
                for (j = 0; j < n; ++j) {
                    rslt.add("");
                }
            }
        }
        String[] srslt = new String[rslt.size()];
        return rslt.toArray(srslt);
    }

    public static String[] formatProcResults(List<Explorable> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split(name));
        }
        int[] witems = new int[snames.size()];
        int icur = 0;
        for (String[] sname : snames) {
            Iterator<Explorable> slast = sname[sname.length - 1];
            int l = ((String)((Object)slast)).indexOf(58);
            witems[icur] = 1;
            if (l >= 0) {
                String s0 = ((String)((Object)slast)).substring(0, l);
                String s1 = ((String)((Object)slast)).substring(l + 1);
                int w = 0;
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                    witems[icur] = w;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++icur;
        }
        ArrayList<String> rslt = new ArrayList<String>();
        int i = 0;
        for (String[] cnames : snames) {
            if (shortname) {
                rslt.add(cnames[cnames.length - 1]);
            } else {
                rslt.add(names.get(i));
            }
            for (int j = 1; j < witems[i]; ++j) {
                rslt.add("");
            }
        }
        for (Explorable record : records) {
            i = 0;
            for (String[] cnames : snames) {
                int j;
                int n = witems[i];
                Object obj = record.getData(InformationSet.concatenate(cnames), Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.add(MatrixFormatter.format(obj, 0));
                        continue;
                    }
                    for (j = 1; j <= n; ++j) {
                        rslt.add(MatrixFormatter.format(obj, j));
                    }
                    continue;
                }
                for (j = 0; j < n; ++j) {
                    rslt.add("");
                }
            }
        }
        String[] srslt = new String[rslt.size()];
        return rslt.toArray(srslt);
    }

    private static String format(Object obj, int item) {
        try {
            InformationFormatter fmt = DICTIONARY.get(obj.getClass());
            return fmt.format(obj, item, LOCALE);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (item == 0) {
                return obj.toString();
            }
            return "";
        }
    }

    @Generated
    private MatrixFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DICTIONARY.put(Double.TYPE, new DoubleFormatter());
        DICTIONARY.put(Integer.TYPE, new IntegerFormatter());
        DICTIONARY.put(Long.TYPE, new LongFormatter());
        DICTIONARY.put(Boolean.TYPE, new BooleanFormatter("1", "0"));
        DICTIONARY.put(Double.class, new DoubleFormatter());
        DICTIONARY.put(Integer.class, new IntegerFormatter());
        DICTIONARY.put(Long.class, new LongFormatter());
        DICTIONARY.put(Boolean.class, new BooleanFormatter("1", "0"));
        DICTIONARY.put(String.class, new StringFormatter());
        DICTIONARY.put(String[].class, new StringArrayFormatter());
        DICTIONARY.put(Parameter.class, new ParameterFormatter());
        DICTIONARY.put(TsPeriod.class, new PeriodFormatter());
        DICTIONARY.put(RegressionItem.class, new RegressionItemFormatter());
        DICTIONARY.put(StatisticalTest.class, new StatisticalTestFormatter());
        DICTIONARY.put(ProcDiagnostic.class, new DiagnosticFormatter());
        DICTIONARY.put(Complex.class, new ComplexFormatter());
        LOCALE = Locale.getDefault();
    }
}

