% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{get_versions}
\alias{get_versions}
\title{Get Package Versions}
\usage{
get_versions(table, package_name)
}
\arguments{
\item{table}{A list of parsed package data, where each element contains package details including package_version.}

\item{package_name}{A character string specifying the name of the package to fetch versions for.}
}
\value{
A list containing:
  - `all_versions`: A character vector of all unique package versions.
  - `last_version`: A character string of the latest version fetched from the RStudio Package Manager, or `NULL` if not available.
}
\description{
This function retrieves all available versions including last version from parse_html_version function'
}
\examples{
\dontrun{
# Define the input table
table <- list(
  list(
    package_name = "here",
    package_version = "0.1",
    link = "here_0.1.tar.gz",
    date = "2017-05-28 08:13",
    size = "3.5K"
  ),
  list(
    package_name = "here",
    package_version = "1.0.0",
    link = "here_1.0.0.tar.gz",
    date = "2020-11-15 18:10",
    size = "32K"
  )
)

# Use the get_versions function
result <- get_versions(table, "here")

# Example output
print(result)
}
}
