% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_dir.R
\name{isDir}
\alias{isDir}
\alias{checkDir}
\alias{assertDir}
\title{Checks existing directory}
\usage{
isDir(...)

checkDir(...)

assertDir(...)
}
\arguments{
\item{\dots}{One or more character strings giving directory names to be
tested}
}
\value{
\code{isDir} returns logical vector.

\code{assertDir} returns an invisible \code{TRUE} if directories exist,
otherwise halts and prints error messages.
}
\description{
Checks whether given character strings point to valid directories
}
\details{
\code{isDir} tests whether the given string represent a valid, existing
directory. \code{assertDir} performs a logical test, and stops the program
if the given string does not point to a given directory.

\code{checkDir} is synonymous to \code{isDir}
}
\examples{

dir1 <- tempdir()
dir2 <- tempdir()

isDir(dir1, dir2)
assertDir(dir1, dir2)

}
\seealso{
\code{\link{file.info}}, \code{\link{checkFile}} and
\code{\link{assertFile}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
