% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustdist.R
\name{robustDist}
\alias{robustDist}
\title{Robust distance}
\usage{
robustDist(x, ...)
}
\arguments{
\item{x}{a numeric matrix, data frame or \sQuote{dist} object}

\item{\dots}{Other parameters passed to the \code{dist} function.}
}
\value{
The same as \code{\link{dist}}, however without \code{NA}s.
}
\description{
A wrapper function for the \code{dist} function in the \code{stats} package.
It replaces NA values in the distance matrix by the maximum distance in the
same matrix, therefore prevents cases where hclust fails because of
\code{NA} distances.
}
\details{
In the rare case of all-NA distance matrices, all values are assigned
arbitrarily to one.
}
\examples{

mymat <- matrix(c(3,2,1,NA,NA,NA,
                4,1,2,NA,NA,NA,
                NA,NA,NA,5,1,2), ncol=6, byrow=TRUE)
dist(mymat)
robustDist(mymat)

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
