% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_illumina_sampleSheet.R
\name{read_illumina_sampleSheet}
\alias{read_illumina_sampleSheet}
\title{Read the Data block of Illumina sample sheet as data.frame}
\usage{
read_illumina_sampleSheet(file, sep = ",")
}
\arguments{
\item{file}{An Illumina SampleSheet, with one Data block}

\item{sep}{Character, separator between columns, comma by default}
}
\value{
A \code{data.frame} of the data block
}
\description{
Read the Data block of Illumina sample sheet as data.frame
}
\examples{
myText <- paste("[Header]",
  "IEMFileVersion,5",
  "",
  "[Reads]",
  "51",
  "1",
  "[Data]",
  "Lane,Sample_ID,Description",
  "1,1,Sample1",
  "1,2,Sample2",
  "2,3,Sample3",
  "2,4,Sample4", sep="\n")
read_illumina_sampleSheet(textConnection(myText))
}
