% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GctMatrix.R
\name{print.GctMatrix}
\alias{print.GctMatrix}
\title{Print method for GctMatrix object}
\usage{
\method{print}{GctMatrix}(x, showAll = FALSE, ...)
}
\arguments{
\item{x}{A GctMatrix object}

\item{showAll}{Logical, whether all values should be printed}

\item{...}{Paramters passed to the default method of \code{print}}
}
\value{
No return value, called for side effects (prints to console).
}
\description{
Print method for GctMatrix object
}
\examples{
m1 <- matrix(1:6, nrow=3, dimnames=list(sprintf("G\%d", 1:3), sprintf("S\%d", 1:2)))
gm1 <- GctMatrix(m1, desc=sprintf("Gene\%d", 1:3))
gm1
mBig <- matrix(round(rnorm(1000),3),
   nrow=100, dimnames=list(sprintf("G\%d", 1:100), sprintf("S\%d", 1:10)))
gmBig <- GctMatrix(mBig, desc=sprintf("Gene\%d", 1:100))
gmBig
\donttest{print(gmBig, showAll=TRUE)}
}
